% Fig4
clear all
clc

load MI_jamming_lowerB_noJ_2;
load MI_jamming_lowerB_noJ_4;
load MI_jamming_lowerB_noJ_811;
load MI_jamming_lowerB_noJ_8choose2;
load naive_MI_secrecy_rate_ssk_GSSK_W
   
figure (1)
plot(SNR,Cssk2_bob,'b-', SNR, Cssk2_eve, 'b-o', SNR, sec_rate2,'b-x',...
    SNR, max(Cssk2_bob_W-Cssk2_eve_W,0),'b-d',...
    SNR,Cssk4_bob,'r-.', SNR, Cssk4_eve, 'r-.+', SNR, sec_rate4,'r-.^',...
    SNR, max(Cssk4_bob_W-Cssk4_eve_W,0),'r-.s',...
    'LineWidth',2)

legend('AMI of Bob with jam., N_t = 2, n_t = 1', ...
    'AMI of Eve with jam., N_t = 2, n_t = 1',...
    'Sec. rate with jam., N_t = 2, n_t = 1',...
    'Sec. rate without jam., N_t = 2, n_t = 1',...
    'AMI of Bob with jam., N_t = 4, n_t = 1',...
    'AMI of Eve with jam., N_t = 4, n_t = 1',...
    'Sec. rate with jam., N_t = 4, n_t = 1',...
    'Sec. rate without jam., N_t = 4, n_t = 1');

grid on;

legend('Location','northwest')
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR(dB)','FontSize',10,'FontWeight','bold');
ylabel('AMI and secrecy rate (bits/symbol)','FontSize',10,'FontWeight','bold')
axis([-5 60 -0.1 3]);

figure (2)
plot(SNR,Cssk8_bob,'k-.', SNR, Cssk8_eve, 'k-.o', SNR, sec_rate8,'k-.x',...
    SNR, max(Cssk8_bob_W-Cssk8_eve_W,0),'k-.d',...
    SNR,Cssk8_bob_8choose2,'m--',SNR, Cssk8_eve_8choose2, 'm--+', ...
    SNR, sec_rate_8choose2,'m--^',...
    SNR, max(Cssk8choose2_bob_W-Cssk8choose2_eve_W,0),'m--s',...
'LineWidth',2)

legend('AMI of Bob with jam., N_t = 8, n_t = 1', ...
    'AMI of Eve with jam., N_t = 8, n_t = 1',...
    'Sec. rate with jam., N_t = 8, n_t = 1',...
    'Sec. rate without jam., N_t = 8, n_t = 1',...
    'AMI of Bob with jam., N_t = 8, n_t = 2',...
    'AMI of Eve with jam., N_t = 8, n_t = 2',...
    'Sec. rate, N_t = 8, n_t = 2',...
    'Sec. rate without jam., N_t = 8, n_t = 2');

grid on;
legend('Location','northwest')
set(gca, 'FontSize', 10,'FontWeight','bold');
xlabel('SNR(dB)','FontSize',10,'FontWeight','bold');
ylabel('AMI and secrecy rate (bits/symbol)','FontSize',10,'FontWeight','bold')
axis([-5 60 -0.1 4.5]);